/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;

public record CreeperType(class_2960 texture, class_2960 glowingTexture, class_2960 chargedTexture, class_2960 model, class_2960 shearedModel, class_2960 animation, int melee, Supplier<class_2248> dirtReplacement, Collection<class_1299<?>> entitiesAfraidOf, Collection<class_1293> inflictingPotions, Collection<class_1293> potionsWhenDead, Collection<Class<? extends class_1309>> entities, Collection<class_1282> immunities, class_5132.class_5133 attributes, boolean shearable) {

    public static class Builder {
        private class_2960 texture;
        private class_2960 glowingTexture;
        private class_2960 chargedTexture;
        private class_2960 model;
        private class_2960 shearedModel;
        private class_2960 animation;
        private int melee = 0;
        private final List<class_1299<?>> afraidOf = new ArrayList();
        private final List<class_1293> inflictingPotions = new ArrayList<class_1293>();
        private final List<class_1293> potionsWhenDying = new ArrayList<class_1293>();
        private final List<Class<? extends class_1309>> attackingEntities = new ArrayList<Class<? extends class_1309>>();
        private final List<class_1282> immunities = new ArrayList<class_1282>();
        private Supplier<class_2248> dirtReplacement = null;
        private final class_5132.class_5133 attributes = BaseCreeper.createAttributes();
        private boolean shearable;

        public Builder setTexture(class_2960 texture) {
            this.texture = texture;
            return this;
        }

        public Builder setGlowingTexture(class_2960 glowingTexture) {
            this.glowingTexture = glowingTexture;
            return this;
        }

        public Builder setChargedTexture(class_2960 chargedTexture) {
            this.chargedTexture = chargedTexture;
            return this;
        }

        public Builder setModel(class_2960 model) {
            this.model = model;
            return this;
        }

        public Builder setShearedModel(class_2960 shearedModel) {
            this.shearedModel = shearedModel;
            return this;
        }

        public Builder setAnimation(class_2960 animation) {
            this.animation = animation;
            return this;
        }

        public Builder setMelee(int melee) {
            this.melee = melee;
            return this;
        }

        public Builder setDirtReplacement(Supplier<class_2248> replacement) {
            this.dirtReplacement = replacement;
            return this;
        }

        public Builder addAfraidOf(class_1299<?> entity) {
            this.afraidOf.add(entity);
            return this;
        }

        public Builder addInflictingPotion(class_1293 potion) {
            this.inflictingPotions.add(potion);
            return this;
        }

        public Builder addPotionsWhenDying(class_1293 potion) {
            this.potionsWhenDying.add(potion);
            return this;
        }

        public Builder addAttackingEntities(Class<? extends class_1309> attackingEntities) {
            this.attackingEntities.add(attackingEntities);
            return this;
        }

        public Builder addImmunity(class_1282 source) {
            this.immunities.add(source);
            return this;
        }

        public Builder addAttribute(class_1320 attribute, double value) {
            this.attributes.method_26868(attribute, value);
            return this;
        }

        public Builder setShearable(boolean shearable) {
            this.shearable = shearable;
            return this;
        }

        public CreeperType build() {
            return new CreeperType(this.texture, this.glowingTexture, this.chargedTexture, this.model, this.shearedModel, this.animation, this.melee, this.dirtReplacement, this.afraidOf, this.inflictingPotions, this.potionsWhenDying, this.attackingEntities, this.immunities, this.attributes, this.shearable);
        }
    }
}

